/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips;

import club.sk1er.mods.scrollabletooltips.Config;
import club.sk1er.mods.scrollabletooltips.universalcraft.UKeyboard;
import club.sk1er.mods.scrollabletooltips.universalcraft.UScreen;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.inventory.Slot;

public class TooltipScroller {
    public static boolean needsReset;
    public static boolean allowScrolling;
    public static double scrollX;
    public static double scrollY;
    public static float zoomFactor;
    public static Slot currentSlot;

    public static void translateTooltip(PoseStack matrixStack, int tooltipY, int tooltipHeight) {
        Screen screen = UScreen.getCurrentScreen();
        assert (screen != null);
        if (needsReset) {
            scrollX = 0.0;
            allowScrolling = tooltipHeight + 12 > screen.f_96544_ || Math.abs(tooltipY) + tooltipHeight > screen.f_96544_;
            scrollY = allowScrolling && Config.startAtTop ? (double)(6 - tooltipY) : 0.0;
            zoomFactor = 1.0f;
            needsReset = false;
        }
        if (!Config.masterToggle) {
            return;
        }
        if (allowScrolling) {
            int max = 6 - tooltipY;
            int min = screen.f_96544_ - tooltipY - tooltipHeight - 6;
            if (scrollY > (double)max) {
                scrollY = max;
            } else if (scrollY < (double)min) {
                scrollY = min;
            }
        }
        matrixStack.m_85837_(scrollX, scrollY, 0.0);
        matrixStack.m_85841_(zoomFactor, zoomFactor, 1.0f);
    }

    public static void resetScroll() {
        needsReset = true;
        allowScrolling = false;
    }

    public static boolean scroll(double delta) {
        if (allowScrolling) {
            if (UKeyboard.isCtrlKeyDown() && Config.zoom) {
                zoomFactor *= (float)(1.0 + 0.1 * Math.signum(delta));
                return true;
            }
            if (UKeyboard.isShiftKeyDown() && Config.horizontalScrolling) {
                scrollX += 10.0 * Math.signum(delta);
                return true;
            }
            if (Config.verticalScrolling) {
                scrollY += 10.0 * Math.signum(delta);
                return true;
            }
        }
        return false;
    }

    static {
        scrollX = 0.0;
        scrollY = 0.0;
        zoomFactor = 1.0f;
    }
}

